

// Utility-function parameters

betaP = 0.99;         // patient HH discount factor
betaI = 0.96;         // impatient HH discount factor
betaE = 0.96;         // entrepreneur discount factor
epsilonP = 0.0837;       // housing preference parameter; patient HHs      
epsilonI = 0.0837;       // housing preference parameter; impatient HHs
nuP = 0.27;            // leisure preference parameter; patient HHs
nuI = 0.27;            // leisure preference parameter; impatient HHs
sigmacP = 1;          // CRRA, consumption, pat. HHs
sigmahP = 1;          // CRRA, housing, pat. HHs       
sigmanP = 9;          // CCRA, leisure, pat. HHs
sigmacI = 1;          // CRRA, consumption, impat. HHs
sigmahI = 1;          // CRRA, housing, impat. HHs         
sigmanI = 9;          // CCRA, leisure, pat. HHs          
sigmacE = 1;          // CRRA, consumption, entrepeneurs

// Technology and related parameters

nI = 1/3 ;            // Fraction of impatient HHs in the economy
nE = 1/3 ;            // Fraction of entrepreneurs in the economy


varthetaI=0.0093;
varthetaE=0.6975;
xiI=0.0144;          
xiE=0.125;  
//xiI=0; xiE=0; varthetaI=1; varthetaE=1;        
                                           
alpha = 0.7;          // patient HHs' share of total labor 
gamma = 0.6355;        // Total labor's share of input factors
phi = 0.1341;            // Land's share of input factors 
delta = 0.0518;         // capital depreciation rate
n = ( (((1-nI-nE)^alpha)*nI^(1-alpha) )^gamma)*nE^(1-gamma);
rhoP = 0.3607;              // Habit formation in consumption, patient - estimated
rhoI = 0.9410;         // Habit formation in consumption, impatient - estimated
rhoE = 0.9410;         // Habit formation in consumption, entrepreneur - estimated
omega = 8.9333;            // Investment adjustment cost parameter - estimated

rhoa = 0.9871;          // AR(1) coefficient for tech shock - estimated
rho_eps = 0.8800;       // AR(1) coefficient for taste shock - estimated
rhos = 0.8532;          // AR(1) coefficient of credit shock - estimated

stdev_ea = 0.0090;     // std.dev. of tech shock innovation - estimated
stdev_eps = 0.0722;  // std.dev. of taste shock innovation - estimated
stdev_es = 0.0329;   // std.dev. of credit shock innovation - estimated